unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  jpeg, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    btnStart: TButton;
    Timer1: TTimer;
    Golyo: TShape;
    procedure btnStartClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    procedure keret();
    procedure szoves();
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.btnStartClick(Sender: TObject);
begin
  // A Start gomb lthatatlann ttele:
  btnStart.Visible := False;

  keret(); // sznes keret rajzolsa
  // Idzt esemnyeinek gyakorisga ezredmsodpercben:
  Timer1.Interval := 50;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  szoves();
end;

// Szivrvnyszn keret rajzolsa
procedure TForm1.Keret();
var i: Longint;
Const szelesseg = 8;
begin
  // Rajzolsi szlessg belltsa:
  Form1.canvas.Pen.Width:= 1;
  // A keret fels s als rsznek rajzolsa:
  for i:=0 to Form1.ClientWidth do
   begin
        // A keret fels lcnek rajzolsa:
        Form1.canvas.Pen.Color:= i*256*256;
        Form1.canvas.MoveTo(i + Szelesseg, 0);
        Form1.canvas.LineTo(i + Szelesseg, Szelesseg);

        // A keret als lcnek rajzolsa:
        Form1.canvas.Pen.Color:= i * 256 * 256+i;
        Form1.canvas.MoveTo(i + Szelesseg, Form1.ClientHeight - Szelesseg);
        Form1.canvas.LineTo(i + Szelesseg, Form1.ClientHeight);
   end;

    // A keret oldals rszeinek rajzolsa:
    for i:= 0 to Form1.ClientHeight do
     begin
        // A keret bal lcnek rajzolsa:
        Form1.canvas.Pen.Color:= i;
        Form1.canvas.MoveTo(1, i);
        Form1.canvas.LineTo(Szelesseg+1, i);

        // A keret jobb lcnek rajzolsa:
        Form1.canvas.Pen.Color:= i * 256;
        Form1.canvas.MoveTo(Form1.ClientWidth-1, i);
        Form1.canvas.LineTo(Form1.ClientWidth - Szelesseg-1, i);
     end;
end;


procedure TForm1.szoves();
const
 dX: Integer=-5;
 dY: Integer=-5;
 szin: Longint=256*256;
 Hatar = 5;
var
  CurrentX, CurrentY :Longint;
begin
  CurrentX := Golyo.Left + Golyo.Width div 2;
  CurrentY := Golyo.Top + Golyo.Height div 2;

    // A goly kerettel val tkzse esetn tlltjuk
    // a nyomvonal sznt, illetve a mozgs irnyt
    if (Golyo.Left <= Hatar) or (Golyo.Left + Golyo.Width >= Form1.ClientWidth - Hatar) Then
     begin
        dX := -dX;
        szin := Form1.canvas.Pixels[CurrentX - dX, CurrentY];
     end;

    if (Golyo.Top <= Hatar) or (Golyo.Top + Golyo.Height >= Form1.ClientHeight - Hatar) Then
     begin
        dY := -dY;
        szin := Form1.canvas.Pixels[CurrentX, CurrentY - dY];
     end;

    // A goly eltolsa:
    Golyo.Left := Golyo.Left + dX;
    Golyo.Top := Golyo.Top + dY;

    Form1.canvas.Pen.Width:= 3;
    // A goly nyomnak kirajzolsa
    Form1.canvas.Pen.Color:= szin;
    Form1.canvas.MoveTo(CurrentX, CurrentY);
    Form1.canvas.LineTo(CurrentX + dX, CurrentY + dY);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  with Form1.Canvas.ClipRect do
  begin
    Left:=0;
    Top:=0;
    Right:=Form1.ClientWidth;
    Bottom:=Form1.ClientHeight;
  end;
end;

end.
